%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% the vector field of the Galerkin expansion of
% L96 model (Eq 4.22)
% Created by John Harlim
% Last edited: March 20, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function rhs = galerkinL96rhs(A,B,F,u,gamma)

    P = size(u,1);
    J = size(u,2);
    rhs = zeros(P,J);
    
    temp = zeros(P,J);
    for j=1:P
        for k=1:P
            temp = temp + repmat(B(:,j,k),1,J).*repmat(circshift(u(j,:),[0 1]).*(circshift(u(k,:),[0 -1])-circshift(u(k,:),[0 2])),P,1);            
        end
    end
    
    for j=1:J
        rhs(:,j) = temp(:,j)./gamma - A*u(:,j) + F;        
    end
    
    
